########################################################################
#' @descricao Leitura dos dados da pesquisa DataSenado e
# exemplo de calculo de estimativas pontuais considerando o delineamento amostral 
#' @author DataSenado
#' @date   07/22
#' @Pesquisa Violencia domestica 2007
########################################################################

rm(list = ls())

## Pacotes ####

library(pacman) # Checa se um pacote esta instalado e em caso afirmativo, carrega-o como faz a funcao 'library'. Se o pacote nao tiver sido instalado, ela primeiramente vai instalar o pacote de carrega-lo em seguida

pacman::p_load(readxl, tidyverse, survey, purrr)

## Diretorios dos arquivos ####

dir = dirname(rstudioapi::getSourceEditorContext()$path) # Diretorio em que o codigo esta salvo

## Microdado ####

df = read.csv2(list.files(dir, "2007 02 Violencia Domestica - DADOS", ignore.case = T,full.names = T), 
               sep = ";") 

names(df)

## Delineamento amostral ####
data.svy <-
  svydesign(
    id = ~ 1, # Sem estrato
    weights = df$W1, ## Para resultar na amostra ponderada
    data = df
  )

summary(data.svy)

# Exemplo de estimativa da proporcao:
(tab <- svymean(~ as.factor(P02), data.svy))
round((qt(0.975,df = degf(data.svy))*SE(tab))*100,1)

# Exemplo de total ponderado/Amostra observada:
svytotal( ~ as.factor(P02), data.svy)
svytotal( ~ as.factor(P19), data.svy)

# Exemplo de tabela cruzada
a = svyby(~ as.factor(P02), ~ as.factor(VD_RENDA), data.svy, svymean)
t(a)

# Teste qui-quadrado para associacao entre variaveis

svychisq(~ P02 + VD_RENDA, data.svy, statistic = c("Chisq"))
